﻿using System;
using NetOffice;
using NetOffice.Attributes;
namespace NetOffice.OWC10Api.Enums
{
	 /// <summary>
	 /// SupportByVersion OWC10 1
	 /// </summary>
	[SupportByVersion("OWC10", 1)]
	[EntityType(EntityType.IsEnum)]
	public enum MsoLanguageID
	{
		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>-2</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMixed = -2,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>0</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDNone = 0,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1024</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDNoProofing = 1024,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1078</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDAfrikaans = 1078,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1052</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDAlbanian = 1052,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5121</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicAlgeria = 5121,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>15361</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicBahrain = 15361,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3073</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicEgypt = 3073,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2049</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicIraq = 2049,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>11265</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicJordan = 11265,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>13313</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicKuwait = 13313,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>12289</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicLebanon = 12289,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4097</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicLibya = 4097,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>6145</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicMorocco = 6145,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>8193</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicOman = 8193,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>16385</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicQatar = 16385,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1025</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabic = 1025,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>10241</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicSyria = 10241,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>7169</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicTunisia = 7169,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>14337</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicUAE = 14337,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>9217</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArabicYemen = 9217,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1067</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDArmenian = 1067,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1101</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDAssamese = 1101,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2092</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDAzeriCyrillic = 2092,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1068</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDAzeriLatin = 1068,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1069</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBasque = 1069,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1059</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDByelorussian = 1059,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1093</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBengali = 1093,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1026</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBulgarian = 1026,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1109</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBurmese = 1109,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1027</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDCatalan = 1027,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3076</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDChineseHongKong = 3076,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5124</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDChineseMacao = 5124,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2052</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSimplifiedChinese = 2052,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4100</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDChineseSingapore = 4100,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1028</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTraditionalChinese = 1028,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1050</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDCroatian = 1050,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1029</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDCzech = 1029,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1030</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDDanish = 1030,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2067</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBelgianDutch = 2067,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1043</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDDutch = 1043,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3081</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishAUS = 3081,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>10249</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishBelize = 10249,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4105</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishCanadian = 4105,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>9225</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishCaribbean = 9225,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>6153</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishIreland = 6153,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>8201</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishJamaica = 8201,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5129</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishNewZealand = 5129,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>13321</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishPhilippines = 13321,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>7177</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishSouthAfrica = 7177,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>11273</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishTrinidad = 11273,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2057</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishUK = 2057,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1033</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishUS = 1033,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>12297</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEnglishZimbabwe = 12297,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1061</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDEstonian = 1061,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1080</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFaeroese = 1080,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1065</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFarsi = 1065,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1035</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFinnish = 1035,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2060</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBelgianFrench = 2060,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>11276</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchCameroon = 11276,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3084</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchCanadian = 3084,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>12300</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchCotedIvoire = 12300,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1036</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrench = 1036,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5132</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchLuxembourg = 5132,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>13324</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchMali = 13324,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>6156</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchMonaco = 6156,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>8204</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchReunion = 8204,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>10252</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchSenegal = 10252,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4108</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwissFrench = 4108,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>7180</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchWestIndies = 7180,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>9228</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrenchZaire = 9228,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1122</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDFrisianNetherlands = 1122,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2108</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGaelicIreland = 2108,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1084</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGaelicScotland = 1084,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1110</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGalician = 1110,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1079</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGeorgian = 1079,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3079</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGermanAustria = 3079,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1031</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGerman = 1031,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5127</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGermanLiechtenstein = 5127,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4103</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGermanLuxembourg = 4103,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2055</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwissGerman = 2055,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1032</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGreek = 1032,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1095</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDGujarati = 1095,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1037</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDHebrew = 1037,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1081</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDHindi = 1081,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1038</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDHungarian = 1038,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1039</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDIcelandic = 1039,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1057</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDIndonesian = 1057,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1040</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDItalian = 1040,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2064</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwissItalian = 2064,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1041</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDJapanese = 1041,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1099</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKannada = 1099,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1120</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKashmiri = 1120,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1087</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKazakh = 1087,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1107</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKhmer = 1107,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1088</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKirghiz = 1088,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1111</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKonkani = 1111,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1042</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDKorean = 1042,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1108</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDLao = 1108,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1062</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDLatvian = 1062,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1063</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDLithuanian = 1063,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1071</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMacedonian = 1071,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1086</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMalaysian = 1086,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2110</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMalayBruneiDarussalam = 2110,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1100</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMalayalam = 1100,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1082</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMaltese = 1082,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1112</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDManipuri = 1112,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1102</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMarathi = 1102,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1104</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMongolian = 1104,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1121</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDNepali = 1121,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1044</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDNorwegianBokmol = 1044,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2068</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDNorwegianNynorsk = 2068,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1096</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDOriya = 1096,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1045</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDPolish = 1045,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1046</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDBrazilianPortuguese = 1046,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2070</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDPortuguese = 2070,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1094</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDPunjabi = 1094,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1047</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDRhaetoRomanic = 1047,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2072</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDRomanianMoldova = 2072,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1048</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDRomanian = 1048,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2073</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDRussianMoldova = 2073,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1049</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDRussian = 1049,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1083</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSamiLappish = 1083,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1103</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSanskrit = 1103,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3098</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSerbianCyrillic = 3098,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2074</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSerbianLatin = 2074,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSesotho = 1072,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1113</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSindhi = 1113,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1051</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSlovak = 1051,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1060</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSlovenian = 1060,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1070</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSorbian = 1070,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>11274</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishArgentina = 11274,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>16394</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishBolivia = 16394,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>13322</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishChile = 13322,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>9226</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishColombia = 9226,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>5130</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishCostaRica = 5130,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>7178</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishDominicanRepublic = 7178,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>12298</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishEcuador = 12298,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>17418</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishElSalvador = 17418,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>4106</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishGuatemala = 4106,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>18442</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishHonduras = 18442,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2058</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDMexicanSpanish = 2058,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>19466</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishNicaragua = 19466,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>6154</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishPanama = 6154,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>15370</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishParaguay = 15370,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>10250</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishPeru = 10250,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>20490</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishPuertoRico = 20490,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>3082</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishModernSort = 3082,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1034</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanish = 1034,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>14346</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishUruguay = 14346,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>8202</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSpanishVenezuela = 8202,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSutu = 1072,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1089</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwahili = 1089,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2077</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwedishFinland = 2077,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1053</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDSwedish = 1053,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1064</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTajik = 1064,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1097</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTamil = 1097,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1092</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTatar = 1092,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1098</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTelugu = 1098,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1054</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDThai = 1054,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1105</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTibetan = 1105,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1073</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTsonga = 1073,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1074</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTswana = 1074,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1055</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTurkish = 1055,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1090</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDTurkmen = 1090,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1058</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDUkrainian = 1058,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1056</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDUrdu = 1056,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>2115</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDUzbekCyrillic = 2115,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1091</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDUzbekLatin = 1091,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1075</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDVenda = 1075,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1066</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDVietnamese = 1066,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1106</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDWelsh = 1106,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1076</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDXhosa = 1076,

		 /// <summary>
		 /// SupportByVersion OWC10 1
		 /// </summary>
		 /// <remarks>1077</remarks>
		 [SupportByVersion("OWC10", 1)]
		 msoLanguageIDZulu = 1077
	}
}